# NODA, NODA-SAC
This repository implements the main algorithm of NODA (as a simulator) and NODA-SAC described in "Model-based Reinforcement Learning with a Hamiltonian Canonical ODE-Inspired Network (submitted to ICLR 2022)". For NODA-SAC, we use NODA to generate imaginary trajectories to facilitate the training of [SAC](http://proceedings.mlr.press/v80/haarnoja18b/haarnoja18b.pdf).

**NOTE:** Check out the code for [Spinning Up](https://spinningup.openai.com/en/latest/), which we mainly build our NODA-SAC on.

## Requirements

To configure your (virtual) environment(python 3.8 recommended), run the following command:
```
$ pip install -r requirements.txt
```

## Instructions

To compare the performance of [HNN](https://arxiv.org/pdf/1906.01563.pdf), AE and NODA on the pixel pendulum task and the real pendulum task, run:
```
$ python simulators_pixel_pendulum_main.py
$ python simulators_real_pendulum_main.py
```
    
To compare the performance of [TD3](http://proceedings.mlr.press/v80/fujimoto18a/fujimoto18a.pdf), [SAC](http://proceedings.mlr.press/v80/haarnoja18b/haarnoja18b.pdf), AE-SAC and NODA-SAC on MuJoCo environments, run:
```
$ python td3_hps.py && bash td3.sh
$ python sac_hps.py && bash td3.sh
$ python noda_sac_hps.py --use-ode 0 && bash noda_sac.sh
$ python noda_sac_hps.py --use-ode 1 && bash noda_sac.sh
$ python draw.py
```
